<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRoleManagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('role_manages')) {
            Schema::create('role_manages', function (Blueprint $table) {
                $table->increments('id');
                $table->string('name')->unique();
                $table->longText('content');
                $table->string('create_by')->nullable();
                $table->string('update_by')->nullable();
                $table->string('delete_by')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('role_manages');
    }
}
